function make_stimulus(num,xstart,ystart,defaults)

global vars handles

plag = defaults(1);
p1height = defaults(2);
p1dur = defaults(3);
pgap = defaults(4);
p2height = defaults(5);
p2dur = defaults(6);

xpos = xstart + 15;
ypos = ystart + 10;
xsp = 5;

vwidth = 15; vheight = 80;
hwidth = 90; hheight = 15;

bwidth = 50; bheight = 20;
boxbgndcolor= [0 0 0];
boxfgndcolor = [1 1 0];

imin = -100; imax = 100;
dmin = 0; dmax = 50;

stimhandle = ['handles.stim' int2str(num)];

stim.defaults = defaults;

stim.lag = uicontrol('Style','slider', ...
    'Position',[xpos ypos hwidth hheight], ...
    'Min',dmin,'Max',dmax,'Value',plag, ...
    'SliderStep',[1 5]/dmax, ...
    'Callback',['callbacks(9,' int2str(num) ')'], ...
    'Tooltips','Offset to Pulse 1');
stim.lagbox = uicontrol('Style','edit', ...
    'Position',[xpos + vwidth + 2, ypos + hheight + 2, bwidth bheight], ...
    'BackgroundColor',boxbgndcolor,'ForegroundColor',boxfgndcolor, ...
    'Callback',['callbacks(10,' int2str(num) ')'], ...
    'Tooltips','Offset to Pulse 1','UserData',stim.lag);
set(stim.lag,'UserData',stim.lagbox)
xpos = xpos + hwidth + xsp*3;

stim.mag1 = uicontrol('Style','slider', ...
    'Position',[xpos ypos vwidth vheight], ...
    'Min',imin,'Max',imax,'Value',p1height, ...
    'SliderStep',[1 5]/(imax-imin), ...
    'Callback',['callbacks(9,' int2str(num) ')'], ... 
    'Tooltips','Pulse 1 height');
stim.magbox1 = uicontrol('Style','edit', ...
    'Position',[xpos + vwidth + 2, ypos + vheight - hheight bwidth bheight], ...
    'BackgroundColor',boxbgndcolor,'ForegroundColor',boxfgndcolor, ...
    'Callback',['callbacks(10,' int2str(num) ')'], ...
    'Tooltips','Pulse 1 height','UserData',stim.mag1);
set(stim.mag1,'UserData',stim.magbox1)
xpos = xpos + vwidth + xsp;

stim.dur1 = uicontrol('Style','slider', ...
    'Position',[xpos ypos hwidth hheight], ...
    'Min',dmin,'Max',dmax,'Value',p1dur,  ...
    'SliderStep',[1 5]/dmax, ...
    'Callback',['callbacks(9,' int2str(num) ')'], ... 
    'Tooltips','Pulse 1 duration');
stim.durbox1 = uicontrol('Style','edit', ...
    'Position',[xpos + vwidth + 2, ypos + hheight + 2, bwidth bheight], ...
    'BackgroundColor',boxbgndcolor,'ForegroundColor',boxfgndcolor, ...
    'Callback',['callbacks(10,' int2str(num) ')'], ...
    'Tooltips','Pulse 1 duration','UserData',stim.dur1);
set(stim.dur1,'UserData',stim.durbox1)
xpos = xpos + hwidth + xsp*3;

stim.gap = uicontrol('Style','slider', ...
    'Position',[xpos ypos hwidth hheight], ...
    'Min',dmin,'Max',dmax,'Value',pgap, ...
    'SliderStep',[1 5]/dmax, ...
    'Callback',['callbacks(9,' int2str(num) ')'], ... 
    'Tooltips','Inter-pulse interval');
stim.gapbox = uicontrol('Style','edit', ...
    'Position',[xpos + vwidth + 2, ypos + hheight + 2, bwidth bheight], ...
    'BackgroundColor',boxbgndcolor,'ForegroundColor',boxfgndcolor, ...
    'Callback',['callbacks(10,' int2str(num) ')'], ...
    'Tooltips','Inter-pulse interval','UserData',stim.gap);
set(stim.gap,'UserData',stim.gapbox)
xpos = xpos + hwidth + xsp*3;

stim.mag2 = uicontrol('Style','slider', ...
    'Position',[xpos ypos vwidth vheight], ...
    'Min',imin,'Max',imax,'Value',p2height, ...
    'SliderStep',[1 5]/(imax-imin), ...
    'Callback',['callbacks(9,' int2str(num) ')'], ... 
    'Tooltips','Pulse 2 height');
stim.magbox2 = uicontrol('Style','edit', ...
    'Position',[xpos + vwidth + 2, ypos + vheight - hheight bwidth bheight], ...
    'BackgroundColor',boxbgndcolor,'ForegroundColor',boxfgndcolor, ...
    'Callback',['callbacks(10,' int2str(num) ')'], ...
    'Tooltips','Pulse 2 height','UserData',stim.mag2);
set(stim.mag2,'UserData',stim.magbox2)
xpos = xpos + vwidth + xsp;

stim.dur2 = uicontrol('Style','slider', ...
    'Position',[xpos ypos hwidth hheight], ...
    'Min',dmin,'Max',dmax,'Value',p2dur, ...
    'SliderStep',[1 5]/dmax, ...
    'Callback',['callbacks(9,' int2str(num) ')'], ... 
    'Tooltips','Pulse 2 duration');
stim.durbox2 = uicontrol('Style','edit', ...
    'Position',[xpos + vwidth + 2, ypos + hheight + 2, bwidth bheight], ...
    'BackgroundColor',boxbgndcolor,'ForegroundColor',boxfgndcolor, ...
    'Callback',['callbacks(10,' int2str(num) ')'], ...
    'Tooltips','Pulse 2 duration','UserData',stim.dur2);
set(stim.dur2,'UserData',stim.durbox2)

stim.axis = axes('Units','pixel', ...
    'Position',[xstart + 45, ystart + vheight + 40, 400 80]);
xlabel('Time (msec)')
ylabel('current (nA)')
title(['Stim' num2str(num) ' Button'],'Color',vars.stimcolor,'FontSize',11)

stim.sliders = [stim.lag stim.mag1 stim.dur1 stim.gap stim.mag2 stim.dur2];
stim.textboxes = [stim.lagbox stim.magbox1 stim.durbox1 stim.gapbox stim.magbox2 stim.durbox2];

str_eval([stimhandle], stim);

