function make_voltage(xstart,ystart,defaults)

global vars handles

p0height = defaults(1);
p0dur = defaults(2);
p1height = defaults(3);
p1dur = defaults(4);
p2height = defaults(5);
p2dur = defaults(6);
p3height = defaults(7);
p3dur = defaults(8);

xpos = xstart + 35;
ypos = ystart;
xsp = 5;

vwidth = 15; vheight = 80;
hwidth = 90; hheight = 15;

bwidth = 50; bheight = 20;
boxbgndcolor= [0 0 0];
boxfgndcolor = [1 1 0];

vmin = -90; vmax = 100;
dmin = 0; dmax = 40;

vc_curve.defaults = defaults;
vc_curve.user_strings = { num2str(defaults(1)) num2str(defaults(2)) ...
                          num2str(defaults(3)) num2str(defaults(4)) ...
                          num2str(defaults(5)) num2str(defaults(6)) ...
                          num2str(defaults(7)) num2str(defaults(7)) };

vc_curve.mag0 = uicontrol('Style','slider', ...
    'Position',[xpos ypos vwidth vheight], ...
    'Min',vmin,'Max',vmax,'Value',p0height, ...
    'SliderStep',[1 5]/(vmax-vmin), ...
    'Callback','callbacks(25)', ...
    'Tooltips','Holding voltage');
vc_curve.magbox0 = uicontrol('Style','edit', ...
    'Position',[xpos + vwidth + 2, ypos + vheight - hheight bwidth bheight], ...
    'BackgroundColor',boxbgndcolor,'ForegroundColor',boxfgndcolor, ...
    'Callback','callbacks(26)', ...
    'Tooltips','Holding voltage','UserData',vc_curve.mag0);
set(vc_curve.mag0,'UserData',vc_curve.magbox0)
vc_curve.vc_sel(1) = uicontrol('Style','radiobutton','Value',0, ...
                        'Callback','vc_varselect(1)',...
                        'Tooltips','Vary holding voltage', ...
                        'Position',[xpos ypos-20 15 15]);
xpos = xpos + vwidth + xsp;


vc_curve.dur0 = uicontrol('Style','slider', ...
    'Position',[xpos ypos hwidth hheight], ...
    'Min',dmin,'Max',dmax,'Value',p0dur, ...
    'SliderStep',[1 5]/dmax, ...
    'Callback','callbacks(25)', ...
    'Tooltips','Hold time');
vc_curve.durbox0 = uicontrol('Style','edit', ...
    'Position',[xpos + vwidth + 2, ypos + hheight + 2, bwidth bheight], ...
    'BackgroundColor',boxbgndcolor,'ForegroundColor',boxfgndcolor, ...
    'Callback','callbacks(26)', ...
    'Tooltips','Hold time','UserData',vc_curve.dur0);
set(vc_curve.dur0,'UserData',vc_curve.durbox0)
vc_curve.vc_sel(2) = uicontrol('Style','radiobutton','Value',0, ...
                        'Callback','vc_varselect(2)',...
                        'Tooltips','Vary hold time', ...
                        'Position',[xpos+hwidth/2 ypos-20 15 15]);
xpos = xpos + hwidth + xsp*6;

vc_curve.mag1 = uicontrol('Style','slider', ...
    'Position',[xpos ypos vwidth vheight], ...
    'Min',vmin,'Max',vmax,'Value',p1height, ...
    'SliderStep',[1 5]/(vmax-vmin), ...
    'Callback','callbacks(25)', ...
    'Tooltips','Step 1 voltage');
vc_curve.magbox1 = uicontrol('Style','edit', ...
    'Position',[xpos + vwidth + 2, ypos + vheight - hheight bwidth bheight], ...
    'BackgroundColor',boxbgndcolor,'ForegroundColor',boxfgndcolor, ...
    'Callback','callbacks(26)', ...
    'Tooltips','Step 1 voltage','UserData',vc_curve.mag1);
set(vc_curve.mag1,'UserData',vc_curve.magbox1)
vc_curve.vc_sel(3) = uicontrol('Style','radiobutton','Value',0, ...
                        'Callback','vc_varselect(3)',...
                        'Tooltips','Vary step 1 voltage', ...
                        'Position',[xpos ypos-20 15 15]);
xpos = xpos + vwidth + xsp;

vc_curve.dur1 = uicontrol('Style','slider', ...
    'Position',[xpos ypos hwidth hheight], ...
    'Min',dmin,'Max',dmax,'Value',p1dur,  ...
    'SliderStep',[1 5]/dmax, ...
    'Callback','callbacks(25)', ...
    'Tooltips','Step 1 duration');
vc_curve.durbox1 = uicontrol('Style','edit', ...
    'Position',[xpos + vwidth + 2, ypos + hheight + 2, bwidth bheight], ...
    'BackgroundColor',boxbgndcolor,'ForegroundColor',boxfgndcolor, ...
    'Callback','callbacks(26)', ...
    'Tooltips','Step 1 duration','UserData',vc_curve.dur1);
set(vc_curve.dur1,'UserData',vc_curve.durbox1)
vc_curve.vc_sel(4) = uicontrol('Style','radiobutton','Value',0, ...
                        'Callback','vc_varselect(4)',...
                        'Tooltips','Vary step 1 duration', ...
                        'Position',[xpos+hwidth/2 ypos-20 15 15]);
xpos = xpos + hwidth + xsp*6;

vc_curve.mag2 = uicontrol('Style','slider', ...
    'Position',[xpos ypos vwidth vheight], ...
    'Min',vmin,'Max',vmax,'Value',p2height, ...
    'SliderStep',[1 5]/(vmax-vmin), ...
    'Callback','callbacks(25)', ...
    'Tooltips','Step 2 voltage');
vc_curve.magbox2 = uicontrol('Style','edit', ...
    'Position',[xpos + vwidth + 2, ypos + vheight - hheight bwidth bheight], ...
    'BackgroundColor',boxbgndcolor,'ForegroundColor',boxfgndcolor, ...
    'Callback','callbacks(26)', ...
    'Tooltips','Step 2 voltage','UserData',vc_curve.mag2);
set(vc_curve.mag2,'UserData',vc_curve.magbox2)
vc_curve.vc_sel(5) = uicontrol('Style','radiobutton','Value',0, ...
                        'Callback','vc_varselect(5)',...
                        'Tooltips','Vary step 2 voltage', ...
                        'Position',[xpos ypos-20 15 15]);
xpos = xpos + vwidth + xsp;

vc_curve.dur2 = uicontrol('Style','slider', ...
    'Position',[xpos ypos hwidth hheight], ...
    'Min',dmin,'Max',dmax,'Value',p2dur, ...
    'SliderStep',[1 5]/dmax, ...
    'Callback','callbacks(25)', ...
    'Tooltips','Step 2 duration');
vc_curve.durbox2 = uicontrol('Style','edit', ...
    'Position',[xpos + vwidth + 2, ypos + hheight + 2, bwidth bheight], ...
    'BackgroundColor',boxbgndcolor,'ForegroundColor',boxfgndcolor, ...
    'Callback','callbacks(26)', ...
    'Tooltips','Step 2 duration','UserData',vc_curve.dur2);
set(vc_curve.dur2,'UserData',vc_curve.durbox2)
vc_curve.vc_sel(6) = uicontrol('Style','radiobutton','Value',0, ...
                        'Callback','vc_varselect(6)',...
                        'Tooltips','Vary step 2 duration', ...
                        'Position',[xpos+hwidth/2 ypos-20 15 15]);
xpos = xpos + hwidth + xsp*6;

vc_curve.mag3 = uicontrol('Style','slider', ...
    'Position',[xpos ypos vwidth vheight], ...
    'Min',vmin,'Max',vmax,'Value',p3height, ...
    'SliderStep',[1 5]/(vmax-vmin), ...
    'Callback','callbacks(25)', ...
    'Tooltips','Step 3 voltage');
vc_curve.magbox3 = uicontrol('Style','edit', ...
    'Position',[xpos + vwidth + 2, ypos + vheight - hheight bwidth bheight], ...
    'BackgroundColor',boxbgndcolor,'ForegroundColor',boxfgndcolor, ...
    'Callback','callbacks(26)', ...
    'Tooltips','Step 3 voltage','UserData',vc_curve.mag3);
set(vc_curve.mag3,'UserData',vc_curve.magbox3)
vc_curve.vc_sel(7) = uicontrol('Style','radiobutton','Value',0, ...
                        'Callback','vc_varselect(7)',...
                        'Tooltips','Vary step 3 voltage', ...
                        'Position',[xpos ypos-20 15 15]);
xpos = xpos + vwidth + xsp;

vc_curve.dur3 = uicontrol('Style','slider', ...
    'Position',[xpos ypos hwidth hheight], ...
    'Min',dmin,'Max',dmax,'Value',p3dur, ...
    'SliderStep',[1 5]/dmax, ...
    'Callback','callbacks(25)', ...
    'Tooltips','Step 3 duration');
vc_curve.durbox3 = uicontrol('Style','edit', ...
    'Position',[xpos + vwidth + 2, ypos + hheight + 2, bwidth bheight], ...
    'BackgroundColor',boxbgndcolor,'ForegroundColor',boxfgndcolor, ...
    'Callback','callbacks(26)', ...
    'Tooltips','Step 3 duration','UserData',vc_curve.dur3);
set(vc_curve.dur3,'UserData',vc_curve.durbox3)
vc_curve.vc_sel(8) = uicontrol('Style','radiobutton','Value',0, ...
                        'Callback','vc_varselect(8)',...
                        'Tooltips','Vary step 3 duration', ...
                        'Position',[xpos+hwidth/2 ypos-20 15 15]);

vc_curve.param_label = uicontrol('style','text','string', ...
  '(*) Parameter being varied', 'FontSize',12,'ForegroundColor','m', ...
  'BackgroundColor','black','Position',[xstart+115 ypos-50 220 20]);

vc_curve.axis = axes('Units','pixel', ...
    'Position',[xstart + 45, ystart + vheight + 40, 540 80]);
xlabel('Time (msec)')
ylabel('voltage (mV)')
title(['Voltage shape'],'Color',vars.vc_color,'FontSize',11)

handles.vc_varval_box = uicontrol('style','edit', ...
  'position', [40 45 250 20], 'backgroundcolor', [0 0 0], ...
  'foregroundcolor', 'm', 'horizontalalignment','left', ...
  'callback','callbacks(33)');


handles.vc_varval_label = uicontrol('style','text','string','', ...
  'ForegroundColor', 'white', 'BackgroundColor','black', ...
  'HorizontalAlignment','left','Position', [40 65 160 20]);

vc_curve.sliders = [vc_curve.mag0 vc_curve.dur0 vc_curve.mag1 vc_curve.dur1 vc_curve.mag2 vc_curve.dur2 vc_curve.mag3 vc_curve.dur3];
vc_curve.textboxes = [vc_curve.magbox0 vc_curve.durbox0 vc_curve.magbox1 vc_curve.durbox1 vc_curve.magbox2 vc_curve.durbox2 vc_curve.magbox3 vc_curve.durbox3];

str_eval('handles.vc_curve', vc_curve);
