function setup_main

  global vars handles

% helps with repeated mouse-clicking
set(0, 'Recursion', 500);

handles.mainwindow = ...
    figure('Unit','pixels','Position',[20 50 800 572]);
clf reset
set(gcf,'Units','normalized')
set(gcf,'CloseRequestFcn','close_all');
set(handles.mainwindow,'Name','HHsim Hodgkin-Huxley Simulator', ...
    'MenuBar','none','NumberTitle','off');
handles.axmain = axes('Position',[0 0.6 1 0.4]);
axis off
set(gcf,'PaperPositionMode','auto');
set(gcf,'InvertHardcopy','on');

handles.mainplot = axes('Position',[0.08 0.53 0.9 0.45]);
set(handles.mainplot,'DrawMode','fast', 'XTickLabelMode', 'auto', ...
    'YTickLabelMode','manual', 'YTick', -100:20:60, ...
    'YTickLabel', -100:20:60, 'ButtonDownFcn', 'set_cursor_vis(''off'')');
make_splot(gca,500,0,[-100 60],{'r' vars.stimcolor})
ylabel('Membrane Voltage (mV)')
grid on, box on
userdata = get(handles.mainplot, 'UserData');
set(userdata.lines(1), 'ButtonDownFcn', 'line_click(1)');
set(userdata.lines(2), 'ButtonDownFcn', 'line_click(2)');

handles.varplot = axes('Position',[0.08 0.3 0.9 0.2]);
set(handles.varplot,'DrawMode','fast', 'ButtonDownFcn', 'set_cursor_vis(''off'')');
set(handles.varplot,'YTickLabelMode', 'manual', ...
    'Ytick', [0 1], 'YTickLabel', ['Low ';'High']);
make_splot(gca,500,0,[-0.1 1.1],{'y' 'g' 'c'})
xlabel('Time (msec)')
grid on, box on
userdata = get(handles.varplot, 'UserData');
set(userdata.lines(1), 'ButtonDownFcn', 'line_click(3)');
set(userdata.lines(2), 'ButtonDownFcn', 'line_click(4)');
set(userdata.lines(3), 'ButtonDownFcn', 'line_click(5)');

linkaxes([handles.mainplot handles.varplot], 'x');
varlist = {'m','h','n','I_Na (uA)','I_K (uA)', 'g_Na (uS)', 'g_K (uS)', 'I_leak (uA)', ...
    'p (user chan)', 'q (user chan)', 'I_user (uA)', 'g_user (uS)', 'blank'};

handles.modebutton = ...
  uicontrol('Style','Popup','Position',[641 1 130 22], ...
    'Value',1,'String',{'Voltage Recording','Voltage Clamp'}, ...
    'FontSize',9, 'Tooltip','Toggle Voltage Clamp mode', ...
    'CallBack','callbacks(23)');

%%%% Var Buttons

handles.v1button = ...
  uicontrol('Style','PopUp','String',varlist,'Value',1, ...
	'Units','pixel','Position',[110 45 100 21], ...
	'Tooltips','Select plot variable', ...
	'BackgroundColor','y','CallBack','change_varplotlines');
handles.v2button = ...
  uicontrol('Style','PopUp','String',varlist,'Value',2, ...
	'Units','pixel','Position',[220 45 100 21], ...
	'Tooltips','Select plot variable', ...
	'BackgroundColor','g','CallBack','change_varplotlines');
handles.v3button = ...
  uicontrol('Style','PopUp','String',varlist,'Value',3, ...
	'Units','pixel','Position',[330 45 100 21], ...
	'Tooltips','Select plot variable', ...
	'BackgroundColor','c','CallBack','change_varplotlines');

handles.v1toptext = uicontrol('Style','text','String', '1','Units','pixel', ...
      'ForegroundColor', 'y', 'Position', [120 68 80 17], ...
      'BackgroundColor','black');
handles.v1bottomtext = uicontrol('Style','text','String', '0','Units','pixel', ...
      'ForegroundColor', 'y', 'Position', [120 25 80 17], ...
      'BackgroundColor','black');
handles.v2toptext = uicontrol('Style','text','String', '1','Units','pixel', ...
      'ForegroundColor', 'g', 'Position', [230 68 80 17], ... 
      'BackgroundColor','black');
handles.v2bottomtext = uicontrol('Style','text','String', '0','Units','pixel', ...
      'ForegroundColor', 'g', 'Position', [230 25 80 17], ...
      'BackgroundColor','black');
handles.v3toptext = uicontrol('Style','text','String', '1','Units','pixel', ...
      'ForegroundColor', 'c', 'Position', [340 68 80 17], ...
      'BackgroundColor','black');
handles.v3bottomtext = uicontrol('Style','text','String', '0','Units','pixel', ...
      'ForegroundColor', 'c', 'Position', [340 25 80 17], ... 
      'BackgroundColor','black');
handles.highlabeltext = uicontrol('style','text','string','High value:', ...
	  'ForegroundColor', 'white', 'BackgroundColor','black', ...
          'Position', [10 68 80 17]);
handles.lowlabeltext = uicontrol('style','text','string','Low value:', ...
	  'ForegroundColor', 'white', 'BackgroundColor','black', ...
          'Position', [10 25 80 17]);

handles.v1axislabel = ...
    uicontrol('Style','Text','Position',[10 210 40 15], ...
    'BackgroundColor','k','ForegroundColor','y', ...
    'HorizontalAlignment','right');
handles.v2axislabel = ...
    uicontrol('Style','Text','Position',[10 190 40 15], ...
    'BackgroundColor','k','ForegroundColor','g', ...
    'HorizontalAlignment','right');
handles.v3axislabel = ...
    uicontrol('Style','Text','Position',[10 170 40 15], ...
    'BackgroundColor','k','ForegroundColor','c', ...
    'HorizontalAlignment','right');

vars.varplotdata_size = 500;
vars.varplotdata = NaN * ones(length(varlist),vars.varplotdata_size);
vars.Vtot_hist = NaN * ones(1,vars.varplotdata_size);
vars.Itot_hist = NaN * ones(1,vars.varplotdata_size);
vars.time_hist = zeros(1,vars.varplotdata_size);

vars.cursorx=1;
store_state;

xwidth = 200 * vars.plot_rate * vars.deltaT_plot * 1e3;

handles.slider = ...
   uicontrol('Style','Slider','Value', xwidth/2, ...
	    'Visible', 'on', ...
            'Min',100 * vars.plot_rate * vars.deltaT_max * 1e3, ...
            'Max',100 * vars.plot_rate * vars.deltaT_max * 1e3 + 1, ...
            'SliderStep',[0.01 1], ...
	    'Position', [42 90 630 15], 'CallBack', 'moveslider'); 
    
slider_set;

handles.cursor = rectangle('Curvature', [1 1], 'visible', 'off', ...
    'HitTest','off');

set_xaxis_limits( xwidth/2 );

figure(handles.mainwindow)
set(gcf,'BackingStore','off')
set(gcf,'Units','pixels');
bx = 5; toprowy = 478;
bw = 80; bh = 22;
handles.membutton = ...
  uicontrol('Style','CheckBox','Position',[bx toprowy bw bh], ...
    'Value',0,'String','Membrane','FontSize',9, ...
    'Tooltip','Toggle membrane window', ...
    'CallBack','callbacks(1)');
bx=bx+bw+3;

handles.chanbutton = ...
  uicontrol('Style','CheckBox','Position',[bx toprowy bw bh], ...
    'Value',0,'String','Channels','FontSize',9, ...
    'Tooltip','Toggle channels window', ...
    'CallBack','callbacks(2)');
bx=bx+bw+3;

handles.stimbutton = ...
  uicontrol('Style','CheckBox','Position',[bx toprowy bw bh], ...
    'Value',0,'String','Stimuli','FontSize',9, ...
    'HorizontalAlignment','left', ...
    'Tooltip','Toggle stimulus window', ...
    'CallBack','callbacks(3)');
handles.vc_button = ...
  uicontrol('Style','CheckBox','Position',[bx toprowy bw bh], ...
    'Value',1,'String','VStim','FontSize',9, ...
    'HorizontalAlignment','left', ...
    'Tooltip','Toggle voltage clamp details window', ...
    'CallBack','callbacks(24)','visible','off');
bx=bx+bw+3;

handles.drugbutton = ...
  uicontrol('Style','CheckBox','Position',[bx toprowy bw bh], ...
    'Value',0,'String','Drugs','FontSize',9, ...
    'HorizontalAlignment','left', ...
    'Tooltip','Toggle drugs window', ...
    'CallBack','callbacks(4)');
bx=bx+bw+3;

handles.stim1button = ...
  uicontrol('Style','PushButton','Position',[5 1 45 20], ...
	'String','Stim1','FontSize',9,'BackgroundColor',vars.stimcolor, ...
	'Tooltip','Stimulus pattern 1', ...
	'CallBack','callbacks(5)');
handles.stim2button = ...
  uicontrol('Style','PushButton','Position',[50 1 45 20], ...
	'String','Stim2','FontSize',9,'BackgroundColor',vars.stimcolor, ...
	'Tooltip','Stimulus pattern 2', ...
	'CallBack','callbacks(6)');

handles.runbutton = ...
  uicontrol('Style','PushButton','Position',[190 1 45 20], ...
	'String','Run','FontSize',9,'BackgroundColor',[0.4 1 0.4], ...
	'Tooltip','Run simulation', ...
	'CallBack','run_system(2)');

handles.nudgebutton = ...
  uicontrol('Style','PushButton','Position',[235 1 45 20], ...
	'String','Nudge','FontSize',9,'BackgroundColor',[0.8 0.8 0.4], ...
	'Tooltip','Run for a few steps', ...
	'CallBack','run_system(1)');

handles.stopbutton = ...
  uicontrol('Style','PushButton','Position',[280 1 45 20], ...
	'String','Stop','FontSize',9,'BackgroundColor',[1 0.4 0.4], ...
	'Tooltip','Stop simulation', ...
	'CallBack','run_system(3)');

handles.printbutton = ...
  uicontrol('Style','PushButton','Position',[355 1 45 20], ...
  'String','Print','FontSize',9, ...
  'Tooltip','Print to file', ...
  'Callback','print_data;');

handles.exportbutton = ...
  uicontrol('Style','PushButton','Position',[400 1 45 20], ...
  'String','Export','FontSize',9, ...
  'Tooltip','Export data to text file', ...
  'Callback','export_data;');

handles.clearbutton = ...
  uicontrol('Style','PushButton','Position',[504 1 45 20], ...
	'String','Clear','FontSize',9, ...
	'Tooltip','Clear plot', ...
	'CallBack','callbacks(7)');

handles.recall_frame = ...
    uicontrol('style', 'frame', 'position', [550 0 56 40], ...
    'backgroundcolor', [0.3 0.1 0.1]);

handles.recallbutton = ...
  uicontrol('Style','PushButton','Position',[556 2 45 20], ...
	'String','Recall','FontSize',9, ...
	'Tooltip','Recall saved state', ...
	'CallBack','callbacks(8)');



handles.zoominbutton = ...
  uicontrol('Style','PushButton','Position',[585 1 55 20], ...
	'String','Zoom in','FontSize',9, ...
	'CallBack','resize_plots(-1)', 'visible', 'off');

handles.zoomoutbutton = ...
  uicontrol('Style','PushButton','Position',[640 1 55 20], ...
	'String','Zoom out','FontSize',9, ...
	'CallBack','resize_plots(1)', 'visible', 'off');

%%%%%%%%% radio buttons
handles.radio_frame = ...
    uicontrol('style', 'frame', 'position', [431 0 185 25], ...
    'backgroundcolor', [.6 .3 .3]);

handles.zoombutton = ...
    uicontrol('Style', 'togglebutton', 'Position', [497 3 55 20], ...
    'String', 'Zoom', 'FontSize', 9, ...
    'CallBack', 'radiobuttons(1)', 'visible', 'on', 'ForegroundColor', 'k', ...
    'value', 0);

handles.panbutton = ...
    uicontrol('Style', 'togglebutton', 'Position', [555 3 55 20], ...
    'String', 'Pan', 'FontSize', 9, ...
    'CallBack', 'radiobuttons(2)', 'visible', 'on', 'ForegroundColor', 'k', ...
    'value',  0);

handles.cursorbutton = ...
    uicontrol('Style', 'togglebutton', 'Position', [437 3 55 20], ...
    'String', 'Cursor', 'FontSize', 9, ...
    'CallBack', 'radiobuttons(3)', 'visible', 'on', 'ForegroundColor', 'r', ...
    'value',  1);
    

handles.helpbutton = ...
  uicontrol('Style','PushButton','Position',[675 toprowy 22 22], ...
        'String','?','FontSize',11,'FontWeight','b', ... 
	'Tooltip','Browse user guide', ...
        'CallBack','help_hhsim');
    
        

%%%%%%%%%%%%%%%% Cursor

handles.cursor_frame = uicontrol('Style','frame', ...
    'Position',[450 25 260 60], ...
    'BackgroundColor',[0.3 0.1 0.1]);

handles.zoom_instruction = uicontrol('Style','text', ...
    'Position',[713 30 90 55], ...
    'BackgroundColor','k', ...
    'ForegroundColor','r', ...
    'String','Click and drag for zooming box, right-click for more options.', ...
    'visible', 'off');

handles.pan_instruction = uicontrol('Style','text', ...
    'Position',[710 45 90 30], ...
    'BackgroundColor','k', ...
    'ForegroundColor','r', ...
    'String','Click and drag to pan', ...
    'visible', 'off');

handles.vc_zoom_instruction = uicontrol('Style','text', ...
    'Position',[290 30 150 50], ...
    'BackgroundColor','k', ...
    'ForegroundColor','r', ...
    'String','Left-click to zoom in, right-click for more options. Click and drag for zooming box', ...
    'visible', 'off');

handles.vc_pan_instruction = uicontrol('Style','text', ...
    'Position',[290 45 150 20], ...
    'BackgroundColor','k', ...
    'ForegroundColor','r', ...
    'String','Click and drag to pan', ...
    'visible', 'off');

handles.cursor_instruction = uicontrol('Style','text', ...
    'Position',[451 30 240 50], ...
    'BackgroundColor',get(handles.cursor_frame,'BackgroundColor'), ...
    'ForegroundColor','w', ...
    'String','Click on any of the lines above to set the cursor and measure the value at that point.');

handles.cursor_text = uicontrol('Style','text','String','','Units','pixel', ...
    'ForegroundColor','black','BackgroundColor','k', 'visible', 'off', ...
    'FontSize',10,'Position',[490 55 90 20]);

handles.cursor_time_text = ...
    uicontrol('Style','text','String','','Units','pixel', ...
    'ForegroundColor','w','BackgroundColor','k', 'visible', 'off', ...
    'FontSize',10,'Position',[588 55 85 20]);

handles.cursor_label_text = ...
    uicontrol('Style','text','String','','Units','pixel', ...
    'BackgroundColor',get(handles.cursor_frame,'BackgroundColor'), ...
    'FontSize',10,'Position',[465 30 90 20]);

handles.changelinebutton = ...
  uicontrol('Style','PushButton','Position',[459 55 23 20], ...
  'String','var','FontSize',9, ...
  'CallBack','move_cursor(0)', 'tooltip', 'move cursor to a different line');

handles.storebutton = ...
  uicontrol('Style','PushButton','Position',[560 30 30 20], ...
  'String','Save','FontSize',9, ...
  'CallBack','store_state', 'tooltip', 'Save state for later recall');

handles.cursor_off = ...
    uicontrol('Style', 'PushButton', 'Position', [688 65 15 15], ...
    'String', 'X', 'FontSiZe', 8, ...
    'tooltip', 'remove cursor', 'CallBack', 'cursor_off', 'visible', 'off');

handles.farleftbutton = ...
  uicontrol('Style','PushButton','Position',[595 30 20 20], ...
  'String','<<','FontSize',9, ...
  'CallBack','move_cursor(-2)', 'tooltip', 'move to next maximum or minimum');

handles.leftbutton = ...
  uicontrol('Style','PushButton','Position',[620 30 20 20], ...
    'String','<','FontSize',9, ...
    'CallBack','move_cursor(-1)', 'tooltip', 'move right one step');

handles.rightbutton = ...
  uicontrol('Style','PushButton','Position',[645 30 20 20], ...
    'String','>','FontSize',9, ...
    'CallBack','move_cursor(1)', 'tooltip', 'move left on step');

handles.farrightbutton = ...
  uicontrol('Style','PushButton','Position',[670 30 20 20], ...
    'String','>>','FontSize',9, ...
    'CallBack','move_cursor(2)', 'tooltip', 'move to next maximum or minimum');

handles.vc_delbutton = ...
  uicontrol('Style','PushButton','Position',[560 30 30 20], ...
  'String','Del','FontSize',9, 'Visible', 'off', ...
  'CallBack','vc_delcurve', 'tooltip', 'Delete this line');

set_cursor_vis('off');

handles.vc_mainplot = axes('Position',[0.08 0.53 0.9 0.45]);
set(handles.vc_mainplot,'DrawMode','fast', 'XTickLabelMode', 'auto', ...
    'ButtonDownFcn', 'set_cursor_vis(''off'')','visible','off');
ylabel('Current (nA)')
grid on, box on

handles.vc_vplot = axes('Position',[0.08 0.3 0.9 0.2]);
set(handles.vc_vplot,'DrawMode','fast', ...
    'YTickLabelMode','manual', ...
    'YTickLabel',[-90:30:60], 'YTick',[-90:30:60],'YLim',[-90 60], ...
    'visible','off');
xlabel('Time (msec)');
ylabel('Voltage (mV)');
grid on, box on


handles.vc_slider = ...
   uicontrol('Style','Slider','Value', xwidth/2, ...
	    'Visible', 'off', ...
            'Min',100 * vars.plot_rate * vars.deltaT_max * 1e3, ...
            'Max',100 * vars.plot_rate * vars.deltaT_max * 1e3 + 1, ...
            'SliderStep',[0.01 1], ...
	    'Position', [42 90 630 15], 'CallBack', 'vc_moveslider'); 
    


pos = get(handles.vc_slider, 'position');




handles.vc_helpnote1 = ...
  uicontrol('Style','text','String','', ...
            'FontSize',12,'ForegroundColor','m','BackgroundColor','black', ...
            'visible','off',...
            'HorizontalAlignment','left','Position',[40 60 190 20]);

handles.vc_helpnote2 = ...
  uicontrol('Style','text','String','   Press "Run" to plot.', ...
            'FontSize',12,'ForegroundColor','white', ...
            'BackgroundColor','black' ,'visible','off',...
            'HorizontalAlignment','left','Position',[40 40 150 20]);

vc_varselect(3,1);
handles.vc_vertslider = ...
   uicontrol('Style','Slider','Value', 50, ...
	    'Visible', 'off', ...
            'Min',0 , ...
            'Max',100 , ...
            'SliderStep',[0.01 .5], ...
	    'Position', [2 349 18 167], 'CallBack', 'vc_movevertslider'); 

handles.yzoominbutton=uicontrol('Style','PushButton','String','+',...
  'Position',[2 450 18 18],'CallBack','callbacks(31)','visible','off');

handles.yzoomoutbutton=uicontrol('Style','PushButton','String','-',...
  'Position',[2 265 18 18],'CallBack','callbacks(32)','visible','off');
vc_vertslider_pos;

vc_clear;






%used to set symbols in translate buttons
updown = 'udrl';
updown(1) = uint8(173);
updown(2) = uint8(175);
updown(3) = uint8(174);
updown(4) = uint8(172);

handles.transupbutton = ...
    uicontrol('Style','PushButton','fontname', 'symbol', 'String',updown(1),...
  'Position',[2 449 18 18],'CallBack','callbacks(34)','visible','off');

handles.transdownbutton = ...
    uicontrol('Style','PushButton','fontname', 'symbol', 'String',updown(2),...
  'Position',[2 266 18 18],'CallBack','callbacks(35)','visible','off');
change_varplotlines  % to set up initial axis labels
linkaxes([handles.vc_mainplot handles.vc_vplot], 'x');
set(handles.mainwindow,'ResizeFcn','resize_main');
vars.move_slider = 0;
resize_main


