function vc_addcurve (varval)
global handles vars

recall_state(2)

%vals will hold data from VStim window
cvals = get(handles.vc_curve.sliders,'Value');
vals = [ cvals{:} ];

%changes to seconds, and separates voltage data from time data
vars.vc_timer = [ ...
 [ vals([1 3 5 7]) 0] * 1e-3; ...
   vals([2 4 6 8]) * 1e-3, Inf];

if (nargin)
  %bound clamped voltage between -100 and 60 mV
  if (varval>60)
    varval=60;
  end
  if (varval<-100)
    varval=-100;
  end

  varval=varval*1e-3;
  vars.vc_timer(mod((handles.vc_varselected-1),2)+1, ...
                ceil(handles.vc_varselected/2)) = varval;
end

vars.vc_time=0;
vars.deltaT=1e-4;
vars.V=vars.vc_timer(1,1);
u=get(handles.vc_mainplot,'UserData');
u.ptr=0; u.cachexdata=[]; u.cacheydata=[]; u.cachecnt=0; u.cachedisp=0;
set(handles.vc_mainplot,'UserData',u);
u=get(handles.vc_vplot,'UserData');
u.ptr=0; u.cachexdata=[]; u.cacheydata=[]; u.cachecnt=0; u.cachedisp=0;
set(handles.vc_vplot,'UserData',u);

if (vars.vc_numcurves>=vars.vc_maxc)
  vars.curve_aborted=1;
  mb=msgbox(['Cannot display more than ' num2str(vars.vc_maxc) ' curves in voltage clamp. Hit the Clear button, or delete some curves.'], 'Warning');
  whitebg(mb);
  set(mb,'Color',[0.7 0.7 0.7]);
else 
  vars.vc_numcurves=vars.vc_numcurves+1;
  vc_iterate
end
